# frozen_string_literal: true

module Types
  # rubocop: disable Graphql/AuthorizeTypes
  class VulnerabilityEvidenceSourceType < BaseObject
    graphql_name 'VulnerabilityEvidenceSource'
    description 'Represents a vulnerability evidence'

    field :identifier,
          GraphQL::Types::String,
          null: false,
          method: :id,
          description: 'ID of the Vulnerability Evidence Source.'

    field :name,
          GraphQL::Types::String,
          null: false,
          description: 'Name of the Vulnerability Evidence Source.'

    field :url,
          GraphQL::Types::String,
          null: true,
          description: 'URL of the Vulnerability Evidence Source.'
  end
  # rubocop: enable Graphql/AuthorizeTypes
end
