# frozen_string_literal: true

module Types
  module VulnerabilityDetails
    # rubocop: disable Graphql/AuthorizeTypes
    class ModuleLocationType < BaseType
      graphql_name 'VulnerabilityDetailModuleLocation'
      description 'Represents the vulnerability details location within a file in the project'

      field :module_name, GraphQL::Types::String,
        null: false, description: 'Module name.'

      field :offset, GraphQL::Types::Int,
        null: false, description: 'Offset of the module location.'
    end
  end
end
