# frozen_string_literal: true

module Types
  class VulnerabilityDetailType < BaseUnion
    graphql_name 'VulnerabilityDetail'
    description 'Represents a vulnerability detail field. The fields with data will depend on the vulnerability detail type'

    UnexpectedReportType = Class.new(StandardError)

    possible_types VulnerabilityDetails::UrlType,
                   VulnerabilityDetails::IntType,
                   VulnerabilityDetails::ListType,
                   VulnerabilityDetails::CodeType,
                   VulnerabilityDetails::TextType,
                   VulnerabilityDetails::DiffType,
                   VulnerabilityDetails::TableType,
                   VulnerabilityDetails::BooleanType,
                   VulnerabilityDetails::CommitType,
                   VulnerabilityDetails::MarkdownType,
                   VulnerabilityDetails::FileLocationType,
                   VulnerabilityDetails::ModuleLocationType,
                   VulnerabilityDetails::BaseType

    def self.resolve_type(object, context)
      case object['type']
      when 'url'                then VulnerabilityDetails::UrlType
      when 'code'               then VulnerabilityDetails::CodeType
      when 'text'               then VulnerabilityDetails::TextType
      when 'diff'               then VulnerabilityDetails::DiffType
      when 'table'              then VulnerabilityDetails::TableType
      when 'commit'             then VulnerabilityDetails::CommitType
      when 'markdown'           then VulnerabilityDetails::MarkdownType
      when 'file-location'      then VulnerabilityDetails::FileLocationType
      when 'module-location'    then VulnerabilityDetails::ModuleLocationType
      when 'list', 'named-list' then VulnerabilityDetails::ListType
      else resolve_type_by_value(object['value'])
      end
    end

    def self.resolve_type_by_value(value)
      case value
      when String                then VulnerabilityDetails::TextType
      when TrueClass, FalseClass then VulnerabilityDetails::BooleanType
      when Integer               then VulnerabilityDetails::IntType
      else                            VulnerabilityDetails::BaseType
      end
    end

    private_class_method :resolve_type_by_value
  end
end
