import { mapActions } from 'vuex';
import { BV_HIDE_MODAL } from '~/lib/utils/constants';
import { VULNERABILITY_MODAL_ID } from '../components/constants';

export const vulnerabilityModalMixin = (storeModule) => {
  const actions = [
    'dismissVulnerability',
    'addDismissalComment',
    'deleteDismissalComment',
    'revertDismissVulnerability',
  ];
  const mapActionsArgs = storeModule ? [storeModule, actions] : [actions];
  return {
    methods: {
      ...mapActions(...mapActionsArgs),
      handleDismissVulnerability(payload) {
        return this.dismissVulnerability(payload).then(this.hideModal);
      },
      handleAddDismissalComment(payload) {
        return this.addDismissalComment(payload).then(this.hideModal);
      },
      handleDeleteDismissalComment(payload) {
        return this.deleteDismissalComment(payload).then(this.hideModal);
      },
      handleRevertDismissVulnerability(payload) {
        return this.revertDismissVulnerability(payload).then(this.hideModal);
      },
      hideModal() {
        if (!this.modal.error) {
          this.$root.$emit(BV_HIDE_MODAL, VULNERABILITY_MODAL_ID);
        }
      },
    },
  };
};
