---
stage: Secure
group: Static Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Secure your application **(FREE)**

GitLab can check your applications for security vulnerabilities.

- [Get started](get-started-security.md)
- [Security configuration](configuration/index.md)
- [Container Scanning](container_scanning/index.md)
- [Dependency Scanning](dependency_scanning/index.md)
- [Static Application Security Testing](sast/index.md)
- [Infrastructure as Code (IaC) Scanning](iac_scanning/index.md)
- [Secret Detection](secret_detection/index.md)
- [Dynamic Application Security Testing (DAST)](dast/index.md)
- [API Fuzzing](api_fuzzing/index.md)
- [Coverage-guided fuzz testing](coverage_fuzzing/index.md)
- [Security Dashboard](security_dashboard/index.md)
- [Offline Environments](offline_deployments/index.md)
- [Vulnerability Report](vulnerability_report/index.md)
- [Vulnerability Page](vulnerabilities/index.md)
- [Vulnerability severity levels](vulnerabilities/severities.md)
- [CVE ID requests](cve_id_request.md)
- [Policies](policies/index.md)
- [Security scanner integration](../../development/integrations/secure.md)
- [Secure and Govern Terminology](terminology/index.md)
