# frozen_string_literal: true

class CleanupVulnerabilityStateTransitionsWithSameFromStateToState < Gitlab::Database::Migration[2.0]
  disable_ddl_transaction!

  restrict_gitlab_migration gitlab_schema: :gitlab_main

  class VulnerabilityStateTransition < MigrationRecord
    self.table_name = 'vulnerability_state_transitions'
  end

  def up
    VulnerabilityStateTransition.where('from_state = to_state').delete_all
  end

  def down
    # no-op
  end
end
