# frozen_string_literal: true

require 'spec_helper'

RSpec.describe VulnerabilityFindingHelpers do
  let(:cls) do
    Class.new do
      include VulnerabilityFindingHelpers

      attr_accessor :report_type

      def initialize(report_type)
        @report_type = report_type
      end
    end
  end

  describe '#requires_manual_resolution?' do
    it 'returns false if the finding does not require manual resolution' do
      expect(cls.new('sast').requires_manual_resolution?).to eq(false)
    end

    it 'returns true when the finding requires manual resolution' do
      expect(cls.new('secret_detection').requires_manual_resolution?).to eq(true)
    end
  end
end
