# frozen_string_literal: true

require "spec_helper"

require_migration!

RSpec.describe RescheduleMigrateSharedVulnerabilityScanners, :migration, feature_category: :vulnerability_management do
  include Gitlab::Database::Migrations::BatchedBackgroundMigrationHelpers

  def connection
    ApplicationRecord.connection
  end

  describe "#up" do
    before do
      migrate!
    end

    it "schedules" do
      expect(described_class::MIGRATION).to have_scheduled_batched_migration(
        table_name: described_class::TABLE_NAME,
        column_name: described_class::BATCH_COLUMN,
        interval: described_class::DELAY_INTERVAL,
        batch_size: described_class::BATCH_SIZE,
        max_batch_size: described_class::BATCH_SIZE,
        sub_batch_size: described_class::SUB_BATCH_SIZE,
        gitlab_schema: :gitlab_main
      )
    end
  end

  describe '#down' do
    before do
      schema_migrate_down!
    end

    it "deletes" do
      expect(described_class::MIGRATION).not_to have_scheduled_batched_migration
    end
  end
end
