import { GlIcon } from '@gitlab/ui';
import { shallowMount } from '@vue/test-utils';
import DetailItem from 'ee/vulnerabilities/components/detail_item.vue';
import VulnerabilityDetailSection from 'ee/vulnerabilities/components/vulnerability_detail_section.vue';
import { extendedWrapper } from 'helpers/vue_test_utils_helper';
import CodeBlock from '~/vue_shared/components/code_block.vue';

describe('VulnerabilityDetails component', () => {
  let wrapper;
  const findHeading = () => wrapper.find('h3');
  const findIcon = () => wrapper.findComponent(GlIcon);
  const findCodeBlock = () => wrapper.findComponent(CodeBlock);
  const findDetailItem = () => wrapper.findComponent(DetailItem);
  const findPlainContent = () => wrapper.findByTestId('detail-item-content-template');

  const createComponent = (
    iconTitle = 'exampleIconTitle',
    heading = 'exampleHeading',
    listData = [
      {
        label: 'Sent request:%{labelEnd}',
        content: 'GET http://nginx\nCache-Control: ',
        isCode: true,
      },
    ],
  ) => {
    wrapper = extendedWrapper(
      shallowMount(VulnerabilityDetailSection, {
        propsData: {
          listData,
          iconTitle,
          heading,
        },
      }),
    );
  };

  afterEach(() => {
    wrapper.destroy();
  });

  it('should render DetailItem Component,', () => {
    createComponent();
    expect(findDetailItem().exists()).toBe(true);
  });

  it('limits the code-blocks maximum height', () => {
    createComponent();
    expect(findCodeBlock().props('maxHeight')).not.toBe(false);
    expect(findCodeBlock().props('maxHeight')).toEqual(expect.any(String));
  });

  describe('if isCode prop is true', () => {
    it('should display code block', () => {
      createComponent();
      expect(findCodeBlock().exists()).toBe(true);
    });

    it('should not display content in plain text', () => {
      createComponent();
      expect(findPlainContent().exists()).toBe(false);
    });
  });

  describe('if isCode prop is false', () => {
    it('should not display code block', () => {
      createComponent('', '', [{ label: '', content: 'testcontent', isCode: false }]);
      expect(findCodeBlock().exists()).toBe(false);
    });

    it('should display content in plain text', () => {
      createComponent('', '', [{ label: '', content: 'testcontent', isCode: false }]);
      expect(findPlainContent().exists()).toBe(true);
    });
  });

  describe('if heading props is set', () => {
    it('should render Heading', () => {
      createComponent();
      expect(findHeading().exists()).toBe(true);
    });
  });

  describe('if heading props is not set', () => {
    it('should not render Heading', () => {
      createComponent('', '');
      expect(findHeading().exists()).toBe(false);
    });
  });

  describe('if iconTitle props is set', () => {
    it('should render Icon', () => {
      createComponent();
      expect(findIcon().exists()).toBe(true);
    });
  });

  describe('if iconTitle props is not set', () => {
    it('should not render Icon', () => {
      createComponent('');
      expect(findIcon().exists()).toBe(false);
    });
  });
});
