import { shallowMountExtended } from 'helpers/vue_test_utils_helper';
import DetailsSection from 'ee/security_dashboard/components/shared/vulnerability_details_graphql/details_section.vue';

describe('ee/security_dashboard/components/shared/vulnerability_details_graphql/details_section.vue', () => {
  let wrapper;

  const createComponent = (options = {}) => {
    wrapper = shallowMountExtended(DetailsSection, {
      ...options,
    });
  };

  afterEach(() => {
    wrapper.destroy();
  });

  it.each(['A heading describing the section', ''])(
    'only renders a heading if the heading-prop is provided',
    (heading) => {
      createComponent({ propsData: { heading } });

      expect(wrapper.findByRole('heading', { level: 2, name: heading }).exists()).toBe(
        Boolean(heading),
      );
    },
  );

  it('renders the default slot', () => {
    const slotContent = 'Useful content describing the section';
    createComponent({ slots: { default: slotContent } });

    expect(wrapper.text()).toContain(slotContent);
  });

  it.each(['List slot content', ''])(
    'only renders a ul if the "list" slot is provided',
    (slotContent) => {
      createComponent({ slots: { list: slotContent } });

      expect(wrapper.findByRole('list').exists()).toBe(Boolean(slotContent));
      if (slotContent) {
        expect(wrapper.text()).toContain(slotContent);
      }
    },
  );
});
