import { shallowMount } from '@vue/test-utils';
import GroupVulnerabilityReport from 'ee/security_dashboard/components/group/group_vulnerability_report.vue';
import VulnerabilityReportTabs from 'ee/security_dashboard/components/shared/vulnerability_report/vulnerability_report_tabs.vue';
import ReportNotConfiguredGroup from 'ee/security_dashboard/components/group/report_not_configured_group.vue';

describe('Group vulnerability report component', () => {
  let wrapper;

  const createWrapper = ({ hasProjects = true } = {}) => {
    wrapper = shallowMount(GroupVulnerabilityReport, {
      provide: { hasProjects },
    });
  };

  const findReportNotConfiguredGroup = () => wrapper.findComponent(ReportNotConfiguredGroup);
  const findVulnerabilityReportTabs = () => wrapper.findComponent(VulnerabilityReportTabs);

  afterEach(() => {
    wrapper.destroy();
  });

  it('shows the report not configured component if there are no projects', () => {
    createWrapper({ hasProjects: false });

    expect(findReportNotConfiguredGroup().exists()).toBe(true);
    expect(findVulnerabilityReportTabs().exists()).toBe(false);
  });

  it('shows the vulnerability report tabs component if there are projects', () => {
    createWrapper({ hasProjects: true });

    expect(findReportNotConfiguredGroup().exists()).toBe(false);
    expect(findVulnerabilityReportTabs().exists()).toBe(true);
  });
});
