export const mockResultSet = {
  seriesNames: () => [
    {
      title: 'pageview, TrackedEvents Count',
      key: 'pageview,TrackedEvents.count',
      yValues: ['pageview', 'TrackedEvents.count'],
    },
  ],
  chartPivot: () => [
    {
      x: '2022-11-09T00:00:00.000',
      xValues: ['2022-11-09T00:00:00.000'],
      'pageview,TrackedEvents.count': 55,
    },
    {
      x: '2022-11-10T00:00:00.000',
      xValues: ['2022-11-10T00:00:00.000'],
      'pageview,TrackedEvents.count': 14,
    },
  ],
  tableColumns: () => [
    {
      key: 'TrackedEvents.utcTime.day',
      title: 'TrackedEvents Utc Time',
      shortTitle: 'Utc Time',
      type: 'time',
      dataIndex: 'TrackedEvents.utcTime.day',
    },
    {
      key: 'TrackedEvents.eventType',
      title: 'TrackedEvents Event Type',
      shortTitle: 'Event Type',
      type: 'string',
      dataIndex: 'TrackedEvents.eventType',
    },
    {
      key: 'TrackedEvents.count',
      type: 'number',
      dataIndex: 'TrackedEvents.count',
      title: 'TrackedEvents Count',
      shortTitle: 'Count',
    },
  ],
  tablePivot: () => [
    {
      'TrackedEvents.utcTime.day': '2022-11-09T00:00:00.000',
      'TrackedEvents.eventType': 'pageview',
      'TrackedEvents.count': '55',
    },
    {
      'TrackedEvents.utcTime.day': '2022-11-10T00:00:00.000',
      'TrackedEvents.eventType': 'pageview',
      'TrackedEvents.count': '14',
    },
  ],
  rawData: () => [
    {
      'TrackedEvents.userLanguage': 'en-US',
      'TrackedEvents.count': '36',
      'TrackedEvents.url': 'https://example.com/us',
    },
    {
      'TrackedEvents.userLanguage': 'es-ES',
      'TrackedEvents.count': '60',
      'TrackedEvents.url': 'https://example.com/es',
    },
  ],
};

export const mockCountResultSet = (count) => ({
  rawData: () => [
    {
      'TrackedEvents.count': count,
    },
  ],
});

export const mockMetaData = {
  cubes: [
    {
      name: 'TrackedEvents',
      title: 'TrackedEvents',
      measures: [
        {
          name: 'TrackedEvents.count',
          title: 'TrackedEvents Count',
          shortTitle: 'Count',
          cumulativeTotal: false,
          cumulative: false,
          type: 'number',
          aggType: 'count',
          drillMembers: [
            'TrackedEvents.eventnCtxEventId',
            'TrackedEvents.idsAjsAnonymousId',
            'TrackedEvents.pageTitle',
            'TrackedEvents.userAnonymousId',
            'TrackedEvents.userHashedAnonymousId',
          ],
          drillMembersGrouped: {
            measures: [],
            dimensions: [
              'TrackedEvents.eventnCtxEventId',
              'TrackedEvents.idsAjsAnonymousId',
              'TrackedEvents.pageTitle',
              'TrackedEvents.userAnonymousId',
              'TrackedEvents.userHashedAnonymousId',
            ],
          },
          isVisible: true,
        },
      ],
      dimensions: [
        {
          name: 'TrackedEvents.apiKey',
          title: 'TrackedEvents Api Key',
          type: 'string',
          shortTitle: 'Api Key',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.docEncoding',
          title: 'TrackedEvents Doc Encoding',
          type: 'string',
          shortTitle: 'Doc Encoding',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.docHost',
          title: 'TrackedEvents Doc Host',
          type: 'string',
          shortTitle: 'Doc Host',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.docPath',
          title: 'TrackedEvents Doc Path',
          type: 'string',
          shortTitle: 'Doc Path',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.docSearch',
          title: 'TrackedEvents Doc Search',
          type: 'string',
          shortTitle: 'Doc Search',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.eventType',
          title: 'TrackedEvents Event Type',
          type: 'string',
          shortTitle: 'Event Type',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.eventnCtxEventId',
          title: 'TrackedEvents Eventn Ctx Event Id',
          type: 'string',
          shortTitle: 'Eventn Ctx Event Id',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.idsAjsAnonymousId',
          title: 'TrackedEvents Ids Ajs Anonymous Id',
          type: 'string',
          shortTitle: 'Ids Ajs Anonymous Id',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.localTzOffset',
          title: 'TrackedEvents Local Tz Offset',
          type: 'string',
          shortTitle: 'Local Tz Offset',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.pageTitle',
          title: 'TrackedEvents Page Title',
          type: 'string',
          shortTitle: 'Page Title',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.parsedUaOsFamily',
          title: 'TrackedEvents Parsed Ua Os Family',
          type: 'string',
          shortTitle: 'Parsed Ua Os Family',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.parsedUaOsVersion',
          title: 'TrackedEvents Parsed Ua Os Version',
          type: 'string',
          shortTitle: 'Parsed Ua Os Version',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.parsedUaUaFamily',
          title: 'TrackedEvents Parsed Ua Ua Family',
          type: 'string',
          shortTitle: 'Parsed Ua Ua Family',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.parsedUaUaVersion',
          title: 'TrackedEvents Parsed Ua Ua Version',
          type: 'string',
          shortTitle: 'Parsed Ua Ua Version',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.referer',
          title: 'TrackedEvents Referer',
          type: 'string',
          shortTitle: 'Referer',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.screenResolution',
          title: 'TrackedEvents Screen Resolution',
          type: 'string',
          shortTitle: 'Screen Resolution',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.sourceIp',
          title: 'TrackedEvents Source Ip',
          type: 'string',
          shortTitle: 'Source Ip',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.src',
          title: 'TrackedEvents Src',
          type: 'string',
          shortTitle: 'Src',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.url',
          title: 'TrackedEvents Url',
          type: 'string',
          shortTitle: 'Url',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.userAgent',
          title: 'TrackedEvents User Agent',
          type: 'string',
          shortTitle: 'User Agent',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.userAnonymousId',
          title: 'TrackedEvents User Anonymous Id',
          type: 'string',
          shortTitle: 'User Anonymous Id',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.userHashedAnonymousId',
          title: 'TrackedEvents User Hashed Anonymous Id',
          type: 'string',
          shortTitle: 'User Hashed Anonymous Id',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.userLanguage',
          title: 'TrackedEvents User Language',
          type: 'string',
          shortTitle: 'User Language',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.vpSize',
          title: 'TrackedEvents Vp Size',
          type: 'string',
          shortTitle: 'Vp Size',
          suggestFilterValues: true,
          isVisible: true,
        },
        {
          name: 'TrackedEvents.utcTime',
          title: 'TrackedEvents Utc Time',
          type: 'time',
          shortTitle: 'Utc Time',
          suggestFilterValues: true,
          isVisible: true,
        },
      ],
      segments: [],
    },
  ],
};

export const mockFilters = {
  startDate: new Date('2015-01-01'),
  endDate: new Date('2016-01-01'),
};
