import { GlAlert, GlSprintf } from '@gitlab/ui';
import { nextTick } from 'vue';
import { shallowMount } from '@vue/test-utils';
import UnableToLinkVulnerabilityError from 'ee/issues/components/unable_to_link_vulnerability_error.vue';
import ClipboardButton from '~/vue_shared/components/clipboard_button.vue';

describe('Unable To Link Vulnerability Error component', () => {
  let wrapper;

  const findAlert = () => wrapper.findComponent(GlAlert);

  const createWrapper = ({ vulnerabilityLink = '' } = {}) => {
    wrapper = shallowMount(UnableToLinkVulnerabilityError, {
      propsData: {
        vulnerabilityLink,
      },
      stubs: { GlSprintf },
    });
  };

  afterEach(() => {
    wrapper.destroy();
  });

  it('shows the vulnerability link', () => {
    const vulnerabilityLink = 'https://gitlab.com';
    createWrapper({ vulnerabilityLink });

    expect(wrapper.html()).toContain(vulnerabilityLink);
  });

  it('hides the error when the alert is dismissed', async () => {
    createWrapper();
    findAlert().vm.$emit('dismiss');
    await nextTick();

    expect(findAlert().exists()).toBe(false);
  });

  it('passes the expected props to the ClipboardButton component', () => {
    createWrapper();

    expect(wrapper.findComponent(ClipboardButton).props()).toMatchObject({
      category: 'primary',
      variant: 'confirm',
      text: window.location.href,
    });
  });
});
