# frozen_string_literal: true

module Sidebars
  module Security
    module Menus
      class VulnerabilityReportMenu < ::Sidebars::Menu
        override :link
        def link
          security_vulnerabilities_path
        end

        override :title
        def title
          _('Vulnerability Report')
        end

        override :sprite_icon
        def sprite_icon
          'list-bulleted'
        end

        override :render?
        def render?
          !!context.current_user
        end

        override :active_routes
        def active_routes
          { path: 'security/vulnerabilities#index' }
        end
      end
    end
  end
end
