# frozen_string_literal: true

module Types
  module VulnerabilityLocation
    # rubocop: disable Graphql/AuthorizeTypes
    class SecretDetectionType < BaseObject
      graphql_name 'VulnerabilityLocationSecretDetection'
      description 'Represents the location of a vulnerability found by a secret detection scan'

      field :vulnerable_class, GraphQL::Types::String,
        null: true, hash_key: :class, description: 'Class containing the vulnerability.'

      field :end_line, GraphQL::Types::String,
        null: true, description: 'Number of the last relevant line in the vulnerable file.'

      field :file, GraphQL::Types::String,
        null: true, description: 'Path to the vulnerable file.'

      field :vulnerable_method, GraphQL::Types::String,
        null: true, hash_key: :method, description: 'Method containing the vulnerability.'

      field :start_line, GraphQL::Types::String,
        null: true, description: 'Number of the first relevant line in the vulnerable file.'

      field :blob_path, GraphQL::Types::String,
        null: true, description: 'Blob path to the vulnerable file.'
    end
  end
end
