# frozen_string_literal: true

module Types
  module VulnerabilityDetails
    # rubocop: disable Graphql/AuthorizeTypes
    class TableType < BaseType
      graphql_name 'VulnerabilityDetailTable'
      description 'Represents the vulnerability details table value'

      field :headers, [VulnerabilityDetailType], null: false, description: 'Table headers.'

      field :rows, [VulnerabilityDetailType], null: false, description: 'Table rows.'

      def headers
        ::Resolvers::Vulnerabilities::DetailsResolver.with_field_name(object[:headers])
      end

      def rows
        ::Resolvers::Vulnerabilities::DetailsResolver.with_field_name(object[:rows])
      end
    end
  end
end
