import { s__, __ } from '~/locale';

export const INSTALL_NPM_PACKAGE = `yarn add @gitlab/application-sdk-js

--

npm i @gitlab/application-sdk-js`;

export const ESM_SETUP_WITH_NPM = `import { glClientSDK } from '@gitlab/application-sdk-js';

this.glClient = glClientSDK({ '$applicationId', '$host' });`;

export const COMMON_JS_SETUP_WITH_NPM = `const { glClientSDK } = require('@gitlab/application-sdk-js');

this.glClient = glClientSDK({ '$applicationId', '$host' });`;

export const HTML_SCRIPT_SETUP = `<script src="https://unpkg.com/@gitlab/application-sdk-js/dist/gl-sdk.min.js"></script>
<script>window.glClient = window.glSDK.glClientSDK({
    applicationId: '$applicationId',
    host: '$host',
});</script>`;

export const JITSU_KEY_CHECK_DELAY = 1000;

export const CUBE_DATA_CHECK_DELAY = 2500;

export const NO_PROJECT_INSTANCE = 'no_project_instance';

export const NO_INSTANCE_DATA = 'no_instance_data';

export const EMPTY_STATE_I18N = {
  empty: {
    title: s__('ProductAnalytics|Analyze your product with Product Analytics'),
    description: s__(
      'ProductAnalytics|Set up Product Analytics to track how your product is performing. Combine it with your GitLab data to better understand where you can improve your product and development processes.',
    ),
    setUpBtnText: s__('ProductAnalytics|Set up product analytics'),
    learnMoreBtnText: __('Learn more'),
  },
  loading: {
    title: s__('ProductAnalytics|Creating your product analytics instance...'),
    description: s__(
      'ProductAnalytics|This might take a while, feel free to navigate away from this page and come back later.',
    ),
  },
};

export const ONBOARDING_VIEW_I18N = {
  unhandledErrorMessage: s__(
    'ProductAnalytics|An error occurred while fetching data. Refresh the page to try again.',
  ),
};
