---
type: howto
stage: Manage
group: Authentication and Authorization
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Enforce two-factor authentication **(FREE)**

Two-factor authentication (2FA) provides an additional level of security to your
users' GitLab account. When enabled, users are prompted for a code generated by an application in
addition to supplying their username and password to sign in.

Read more about [two-factor authentication (2FA)](../user/profile/account/two_factor_authentication.md)

## Enforce 2FA for all users **(FREE SELF)**

Users on GitLab can enable it without any administrator's intervention. If you
want to enforce everyone to set up 2FA, you can choose from two different ways:

- Enforce on next login.
- Suggest on next login, but allow a grace period before enforcing.

After the configured grace period has elapsed, users can sign in but
cannot leave the 2FA configuration area at `/-/profile/two_factor_auth`.

To enable 2FA for all users:

1. On the top bar, select **Main menu > Admin**.
1. On the left sidebar, select **Settings > General** (`/admin/application_settings/general`).
1. Expand the **Sign-in restrictions** section, where you can configure both.

If you want 2FA enforcement to take effect during the next sign-in attempt,
change the grace period to `0`.

### Disable 2FA enforcement through Rails console

Using the [Rails console](../administration/operations/rails_console.md), enforcing 2FA for
all user can be disabled. Connect to the Rails console and run:

```ruby
Gitlab::CurrentSettings.update!('require_two_factor_authentication': false)
```

## Enforce 2FA for all users in a group **(FREE)**

> [Introduced](https://gitlab.com/gitlab-org/gitlab-foss/-/merge_requests/24965) in GitLab 12.0, 2FA settings for a group are also applied to subgroups.

Prerequisites:

- You must have the Maintainer or Owner role for the group.

To enforce 2FA only for certain groups:

1. On the top bar, select **Main menu > Groups** and find your group.
1. On the left sidebar, select **Settings > General**.
1. Expand **Permissions and group features**.
1. Select **All users in this group must set up two-factor authentication**.
1. Select **Save changes**.

You can also specify a grace period in the **Delay 2FA enforcement** option.

If you want to enforce 2FA only for certain groups, you can enable it in the
group settings and specify a grace period as above.

The following are important notes about 2FA:

- Projects belonging to a 2FA-enabled group that
  [is shared](../user/project/members/share_project_with_groups.md)
  with a 2FA-disabled group will *not* require members of the 2FA-disabled group to use
  2FA for the project. For example, if project *P* belongs to 2FA-enabled group *A* and
  is shared with 2FA-disabled group *B*, members of group *B* can access project *P*
  without 2FA. To ensure this scenario doesn't occur,
  [prevent sharing of projects](../user/group/access_and_permissions.md#prevent-a-project-from-being-shared-with-groups)
  for the 2FA-enabled group.
- If you add additional members to a project within a group or subgroup that has
  2FA enabled, 2FA is **not** required for those individually added members.
- If there are multiple 2FA requirements (for example, group + all users, or multiple
  groups) the shortest grace period is used.
- It is possible to prevent subgroups from setting up their own 2FA requirements:
  1. Go to the top-level group's **Settings > General**.
  1. Expand the **Permissions and group features** section.
  1. Uncheck the **Allow subgroups to set up their own two-factor authentication rule** field.

  This action causes all subgroups with 2FA requirements to stop requiring that from their members.
- Access tokens are not required to provide a second factor for authentication because they are API-based.
  Tokens generated before 2FA is enforced remain valid.

## Disable 2FA **(FREE SELF)**

WARNING:
Disabling 2FA for users does not disable the [enforce 2FA for all users](#enforce-2fa-for-all-users)
or [enforce 2FA for all users in a group](#enforce-2fa-for-all-users-in-a-group)
settings. You must also disable any enforced 2FA settings so users aren't asked to set up 2FA again
when they next sign in to GitLab.

WARNING:
This is a permanent and irreversible action. Users must reactivate 2FA to use it again.

### For a single user

To disable 2FA for non-administrator users, you should use the [API endpoint](../api/users.md#disable-two-factor-authentication)
instead of the Rails console.
Using the [Rails console](../administration/operations/rails_console.md), 2FA for a single user can be disabled.
Connect to the Rails console and run:

**In GitLab 13.5 and later:**

```ruby
admin = User.find_by_username('<USERNAME>')
user_to_disable = User.find_by_username('<USERNAME>')

TwoFactor::DestroyService.new(admin, user: user_to_disable).execute
```

The target user is notified that 2FA has been disabled.

### For all users

There may be some special situations where you want to disable 2FA for everyone
even when forced 2FA is disabled. There is a Rake task for that:

```shell
# Omnibus installations
sudo gitlab-rake gitlab:two_factor:disable_for_all_users

# Installations from source
sudo -u git -H bundle exec rake gitlab:two_factor:disable_for_all_users RAILS_ENV=production
```

## 2FA for Git over SSH operations **(PREMIUM)**

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/270554) in GitLab 13.7.
> - [Moved](https://gitlab.com/gitlab-org/gitlab/-/issues/299088) from GitLab Free to GitLab Premium in 13.9.
> - It's deployed behind a feature flag, disabled by default.
> - Push notification support [introduced](https://gitlab.com/gitlab-org/gitlab-shell/-/issues/506) in GitLab 15.3.

FLAG:
On self-managed GitLab, by default this feature is not available. To make it available, ask an administrator to [enable the feature flag](../administration/feature_flags.md) named `two_factor_for_cli`. On GitLab.com, this feature is not available. The feature is not ready for production use. This feature flag also affects [session duration for Git Operations when 2FA is enabled](../user/admin_area/settings/account_and_limit_settings.md#customize-session-duration-for-git-operations-when-2fa-is-enabled).

You can enforce 2FA for [Git over SSH operations](../development/gitlab_shell/features.md#git-operations). However, you should use
[ED25519_SK](../user/ssh.md#ed25519_sk-ssh-keys) or [ECDSA_SK](../user/ssh.md#ecdsa_sk-ssh-keys) SSH keys instead. 2FA is enforced for Git operations only, and internal commands such as [`personal_access_token`](../development/gitlab_shell/features.md#personal-access-token) are excluded.

To perform one-time password (OTP) verification, run:

```shell
ssh git@<hostname> 2fa_verify
```

Then authenticate by either:

- Entering the correct OTP.
- In GitLab 15.3 and later, responding to a device push notification if
  [FortiAuthenticator is enabled](../user/profile/account/two_factor_authentication.md#enable-one-time-password-using-fortiauthenticator).

After successful authentication, you can perform [Git over SSH operations](../development/gitlab_shell/features.md#git-operations) for 15 minutes (default) with the associated
SSH key.

### Security limitation

2FA does not protect users with compromised *private* SSH keys.

Once an OTP is verified, anyone can run Git over SSH with that private SSH key for
the configured [session duration](../user/admin_area/settings/account_and_limit_settings.md#customize-session-duration-for-git-operations-when-2fa-is-enabled).

<!-- ## Troubleshooting

Include any troubleshooting steps that you can foresee. If you know beforehand what issues
one might have when setting this up, or when something is changed, or on upgrading, it's
important to describe those, too. Think of things that may go wrong and include them here.
This is important to minimize requests for support, and to avoid doc comments with
questions that you know someone might ask.

Each scenario can be a third-level heading, for example `### Getting error message X`.
If you have none to add when creating a doc, leave this section in place
but commented out to help encourage others to add to it in the future. -->
