# frozen_string_literal: true

# See https://docs.gitlab.com/ee/development/migration_style_guide.html
# for more information on how to write migrations for GitLab.

class RemoveVulnerabilityApprovalRules < Gitlab::Database::Migration[2.0]
  disable_ddl_transaction!

  restrict_gitlab_migration gitlab_schema: :gitlab_main

  class ApprovalProjectRule < MigrationRecord
    self.table_name = 'approval_project_rules'

    enum report_type: { vulnerability: 1, license_scanning: 2, code_coverage: 3, scan_finding: 4 }
  end

  def up
    return unless Gitlab.ee?

    ApprovalProjectRule.reset_column_information

    ApprovalProjectRule.vulnerability.delete_all
  end

  def down
    # no-op
    # Vulnerability-Check feature has been removed as part of 15.0
  end
end
