# frozen_string_literal: true

class UpdateVulnerabilityOccurrencesLocation < Gitlab::Database::Migration[1.0]
  BATCH_SIZE = 20_000
  DELAY_INTERVAL = 3.minutes
  MIGRATION_NAME = 'UpdateVulnerabilityOccurrencesLocation'

  disable_ddl_transaction!

  def up
    return unless Gitlab.ee?

    relation = Gitlab::BackgroundMigration::UpdateVulnerabilityOccurrencesLocation::Occurrence.where(location: nil)
    queue_background_migration_jobs_by_range_at_intervals(relation,
                                                          MIGRATION_NAME,
                                                          DELAY_INTERVAL,
                                                          batch_size: BATCH_SIZE,
                                                          track_jobs: true)
  end

  def down
    # no-op
  end
end
