# frozen_string_literal: true

class AddOccurrenceIdIdDescIndexToVulnerabilityOccurrencePipelines < Gitlab::Database::Migration[1.0]
  disable_ddl_transaction!

  INDEX_NAME = "index_vulnerability_occurrence_pipelines_occurrence_id_and_id"

  def up
    add_concurrent_index(
      :vulnerability_occurrence_pipelines,
      [:occurrence_id, :id],
      order: { id: :desc },
      name: INDEX_NAME
    )
  end

  def down
    remove_concurrent_index_by_name(
      :vulnerability_occurrence_pipelines,
      INDEX_NAME
    )
  end
end
