# frozen_string_literal: true

class AddMergeRequestsForeignKeyToVulnerabilityMergeRequestLinks < Gitlab::Database::Migration[2.0]
  disable_ddl_transaction!

  def up
    add_concurrent_foreign_key :vulnerability_merge_request_links, :merge_requests, column:
      :merge_request_id, on_delete: :cascade
  end

  def down
    with_lock_retries do
      remove_foreign_key :vulnerability_merge_request_links, column: :merge_request_id
    end
  end
end
