# frozen_string_literal: true

class RemoveIndexForVulnerabilityOccurrences < Gitlab::Database::Migration[1.0]
  INDEX_NAME = 'index_vulnerability_occurrences_on_unique_keys'

  disable_ddl_transaction!

  def up
    remove_concurrent_index_by_name :vulnerability_occurrences, INDEX_NAME
  end

  def down
    # no-op

    # The index is UNIQUE so we cannot add it back again
  end
end
