# frozen_string_literal: true

require 'spec_helper'

require_migration!

RSpec.describe ScheduleBackfillingTheNamespaceIdForVulnerabilityReads, feature_category: :vulnerability_management do
  let!(:migration) { described_class::MIGRATION_NAME }

  describe '#up' do
    it 'schedules background jobs for each batch of vulnerabilities' do
      migrate!

      expect(migration).to have_scheduled_batched_migration(
        table_name: :vulnerability_reads,
        column_name: :vulnerability_id,
        interval: 2.minutes,
        batch_size: 10_000,
        sub_batch_size: 200
      )
    end
  end

  describe '#down' do
    it 'deletes all batched migration records' do
      migrate!
      schema_migrate_down!

      expect(migration).not_to have_scheduled_batched_migration
    end
  end
end
