# frozen_string_literal: true

require 'spec_helper'

RSpec.describe VulnerabilityPolicy do
  describe 'read_security_resource' do
    let(:project) { create(:project) }
    let(:user) { create(:user) }
    let(:vulnerability) { create(:vulnerability, project: project) }

    subject { described_class.new(user, vulnerability) }

    context 'when the security_dashboard feature is enabled' do
      before do
        stub_licensed_features(security_dashboard: true)
      end

      context "when the current user is not a project member" do
        it { is_expected.to be_disallowed(:read_security_resource) }
        it { is_expected.to be_disallowed(:create_note) }
      end

      context "when the current user has developer access to the vulnerability's project" do
        before do
          project.add_developer(user)
        end

        it { is_expected.to be_allowed(:read_security_resource) }
        it { is_expected.to be_allowed(:create_note) }
      end

      context 'when the user is project member but does not have proper access' do
        before do
          project.add_guest(user)
        end

        it { is_expected.to be_disallowed(:create_note) }
      end
    end

    context 'when the security_dashboard feature is disabled' do
      before do
        stub_licensed_features(security_dashboard: false)

        project.add_developer(user)
      end

      it { is_expected.to be_disallowed(:read_security_resource) }
      it { is_expected.to be_disallowed(:create_note) }
    end
  end
end
