import { GlLink } from '@gitlab/ui';
import VulnerabilityReportHeader from 'ee/security_dashboard/components/shared/vulnerability_report/vulnerability_report_header.vue';
import { mountExtended } from 'helpers/vue_test_utils_helper';
import CsvExportButton from 'ee/security_dashboard/components/shared/csv_export_button.vue';
import { DOC_PATH_VULNERABILITY_REPORT } from 'ee/security_dashboard/constants';

describe('Vulnerability report header component', () => {
  let wrapper;

  const createWrapper = ({ provide } = {}) => {
    wrapper = mountExtended(VulnerabilityReportHeader, {
      provide,
      stubs: { CsvExportButton: true, GlButton: true },
    });
  };

  it('shows the submit vulnerability button when new vulnerability path is defined', () => {
    createWrapper({
      provide: {
        canAdminVulnerability: true,
        newVulnerabilityPath: '/vulnerabilities/new',
      },
    });

    expect(wrapper.findByText('Submit vulnerability').attributes('href')).toBe(
      '/vulnerabilities/new',
    );
  });

  it('does not show the submit vulnerability button when new vulnerability path is not defined', () => {
    createWrapper({
      provide: {
        canAdminVulnerability: true,
      },
    });

    expect(wrapper.findByText('Submit vulnerability').exists()).toBe(false);
  });

  it('does not should the submit vulnerability button when user cannot admin vulnerabilities', () => {
    createWrapper({
      provide: {
        canAdminVulnerability: false,
        newVulnerabilityPath: '/vulnerabilities/new',
      },
    });

    expect(wrapper.findByText('Submit vulnerability').exists()).toBe(false);
  });

  it('shows the CSV export button', () => {
    createWrapper();

    expect(wrapper.findComponent(CsvExportButton).exists()).toBe(true);
  });

  it('shows the correct link for the documentation', () => {
    createWrapper();

    expect(wrapper.findComponent(GlLink).attributes('href')).toBe(DOC_PATH_VULNERABILITY_REPORT);
  });
});
