# frozen_string_literal: true

module Gitlab
  module Vulnerabilities
    class StandardVulnerability < BaseVulnerability
      include RequestAwareEntity

      def title
        @data[:title].presence || @data[:name]
      end

      def description
        @data[:description].presence || title
      end

      def file
        @data[:file].presence || @data.dig(:location, :file)
      end

      def line
        @data[:line].presence || @data.dig(:location, :start_line)
      end

      def location_text
        return file unless line

        "#{file}:#{line}"
      end

      def blob_path
        path = @data[:blob_path] || @data.dig(:location, :blob_path)
        return unless path

        path.gsub(%r{^/}, '')
      end

      def location_link
        return location_text unless blob_path

        "#{root_url}#{blob_path}"
      end
    end
  end
end
