# frozen_string_literal: true

module Security
  # Service for counting the number of vulnerability findings for
  # an array of report types within a pipeline
  #
  class VulnerabilityCountingService
    # @param [Ci::Pipeline] pipeline
    # @param Array[String] report_types Summary report types. Valid values are members of Enums::Vulnerability.report_types
    def initialize(pipeline, report_types)
      @pipeline = pipeline
      @report_types = report_types
    end

    def execute
      counts = @pipeline.security_findings
                        .deduplicated
                        .by_report_types(@report_types)
                        .count_by_scan_type

      counts.transform_keys { |key| Security::Scan.scan_types.key(key) }.reverse_merge(no_counts)
    end

    def no_counts
      @report_types.zip([0].cycle).to_h
    end
  end
end
