# frozen_string_literal: true

module Types
  # rubocop: disable Graphql/AuthorizeTypes
  class VulnerabilitySeveritiesCountType < BaseObject
    graphql_name 'VulnerabilitySeveritiesCount'
    description 'Represents vulnerability counts by severity'

    ::Enums::Vulnerability.severity_levels.keys.each do |severity|
      field severity,
            GraphQL::Types::Int,
            null: true,
            description: "Number of vulnerabilities of #{severity.upcase} severity of the project"
    end
  end
end
