# frozen_string_literal: true

module Types
  module VulnerabilityDetails
    # rubocop: disable Graphql/AuthorizeTypes
    class CommitType < BaseType
      graphql_name 'VulnerabilityDetailCommit'
      description 'Represents the vulnerability details commit field'

      field :value, GraphQL::Types::String, null: false, description: 'Commit SHA value.'
    end
  end
end
