# frozen_string_literal: true

module Projects
  module Security
    class VulnerabilityReportController < Projects::ApplicationController
      include SecurityAndCompliancePermissions
      include SecurityDashboardsPermissions

      before_action do
        push_frontend_feature_flag(:refactor_vulnerability_tool_filter, @project)
        push_frontend_feature_flag(:refactor_vulnerability_filters, current_user)
      end

      feature_category :vulnerability_management
      urgency :low

      alias_method :vulnerable, :project
    end
  end
end
