---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Issues **(FREE)**

Use issues to collaborate on ideas, solve problems, and plan work.
Share and discuss proposals with your team and with outside collaborators.

You can use issues for many purposes, customized to your needs and workflow.

- Discuss the implementation of an idea.
- Track tasks and work status.
- Accept feature proposals, questions, support requests, or bug reports.
- Elaborate on code implementations.

For more information about using issues, see the GitLab blog post:
[Always start a discussion with an issue](https://about.gitlab.com/blog/2016/03/03/start-with-an-issue/).

Issues are always associated with a specific project. If you have multiple
projects in a group, you can view all of the projects' issues at once.

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>
To learn how the GitLab Strategic Marketing department uses GitLab issues with [labels](../labels.md) and
[issue boards](../issue_board.md), see the video on
[Managing Commitments with Issues](https://www.youtube.com/watch?v=cuIHNintg1o&t=3).

## Related topics

- [Create issues](create_issues.md)
- [Create an issue from a template](../../project/description_templates.md#use-the-templates)
- [Edit issues](managing_issues.md#edit-an-issue)
- [Move issues](managing_issues.md#move-an-issue)
- [Close issues](managing_issues.md#close-an-issue)
- [Delete issues](managing_issues.md#delete-an-issue)
- [Promote issues](managing_issues.md#promote-an-issue-to-an-epic)
- [Set a due date](due_dates.md)
- [Import issues](csv_import.md)
- [Export issues](csv_export.md)
- [Upload designs to issues](design_management.md)
- [Linked issues](related_issues.md)
- [Similar issues](managing_issues.md#similar-issues)
- [Health status](managing_issues.md#health-status)
- [Cross-link issues](crosslinking_issues.md)
- [Sort issue lists](sorting_issue_lists.md)
- [Search for issues](managing_issues.md#filter-the-list-of-issues)
- [Epics](../../group/epics/index.md)
- [Issue boards](../issue_board.md)
- [Issues API](../../../api/issues.md)
- [Configure an external issue tracker](../../../integration/external-issue-tracker.md)
- [Tasks](../../tasks.md)
