# frozen_string_literal: true

class ScheduleBackfillingTheNamespaceIdForVulnerabilityReads < Gitlab::Database::Migration[2.0]
  MIGRATION_NAME = 'BackfillNamespaceIdOfVulnerabilityReads'

  restrict_gitlab_migration gitlab_schema: :gitlab_main
  disable_ddl_transaction!

  def up
    queue_batched_background_migration(
      MIGRATION_NAME,
      :vulnerability_reads,
      :vulnerability_id,
      job_interval: 2.minutes,
      batch_size: 10_000,
      sub_batch_size: 200
    )
  end

  def down
    delete_batched_background_migration(MIGRATION_NAME, :vulnerability_reads, :vulnerability_id, [])
  end
end
