# frozen_string_literal: true

RSpec.shared_examples 'calls vulnerability statistics utility services in order' do
  before do
    vulnerability.clear_changes_information

    allow(SystemNoteService).to receive(:change_vulnerability_state) { |vulnerability, *| vulnerability.clear_changes_information }
    allow(Vulnerabilities::Statistics::UpdateService).to receive(:update_for)
  end

  context 'when updating the vulnerability fails' do
    before do
      allow(vulnerability).to receive(:update).and_return(false)
    end

    it 'does not call the service classes' do
      subject

      expect(SystemNoteService).not_to have_received(:change_vulnerability_state).ordered
      expect(Vulnerabilities::Statistics::UpdateService).not_to have_received(:update_for).ordered
    end
  end

  context 'when updating the vulnerability succeeds' do
    it 'calls the service classes in order' do
      subject

      expect(SystemNoteService).to have_received(:change_vulnerability_state).ordered
      expect(Vulnerabilities::Statistics::UpdateService).to have_received(:update_for).ordered
    end
  end
end
