# frozen_string_literal: true

require 'spec_helper'

RSpec.describe ::EE::API::Entities::VulnerabilityExport do
  let(:vulnerability_export) { create(:vulnerability_export, :finished, :csv, :with_csv_file) }

  let(:entity) { described_class.new(vulnerability_export) }

  subject { entity.as_json }

  it 'contains vulnerability export properties' do
    aggregate_failures do
      expect(subject[:id]).to eq(vulnerability_export.id)
      expect(subject[:created_at]).to eq(vulnerability_export.created_at)
      expect(subject[:project_id]).to eq(vulnerability_export.project_id)
      expect(subject[:group_id]).to eq(vulnerability_export.group_id)
      expect(subject[:format]).to eq(vulnerability_export.format)
      expect(subject[:status]).to eq(vulnerability_export.status)
      expect(subject[:started_at]).to eq(vulnerability_export.started_at)
      expect(subject[:finished_at]).to eq(vulnerability_export.finished_at)
      expect(subject[:_links][:self]).to end_with("api/v4/security/vulnerability_exports/#{vulnerability_export.id}")
      expect(subject[:_links][:download]).to end_with("api/v4/security/vulnerability_exports/#{vulnerability_export.id}/download")
    end
  end
end
