import { shallowMount } from '@vue/test-utils';
import VulnerabilityDetail from 'ee/vue_shared/security_reports/components/vulnerability_detail.vue';

describe('VulnerabilityDetail component', () => {
  let wrapper;

  const factory = ({ propsData, defaultSlot }) => {
    wrapper = shallowMount(VulnerabilityDetail, {
      propsData,
      slots: {
        default: defaultSlot,
      },
    });
  };

  afterEach(() => {
    wrapper.destroy();
  });

  it('renders the label prop and default slot', () => {
    factory({ propsData: { label: 'foo' }, defaultSlot: '<p>bar</p>' });

    expect(wrapper.element).toMatchSnapshot();
  });
});
