import { GlTab, GlBadge } from '@gitlab/ui';
import { shallowMount } from '@vue/test-utils';
import { nextTick } from 'vue';
import VulnerabilityReportTab from 'ee/security_dashboard/components/shared/vulnerability_report/vulnerability_report_tab.vue';
import VulnerabilityReport from 'ee/security_dashboard/components/shared/vulnerability_report/vulnerability_report.vue';

describe('Vulnerability report tab component', () => {
  let wrapper;

  const createWrapper = ({
    title = '',
    isActiveTab = false,
    filterDropdowns = [],
    fields = [],
    filterFn,
    headerSlot = '',
  } = {}) => {
    wrapper = shallowMount(VulnerabilityReportTab, {
      propsData: {
        title,
        isActiveTab,
        filterDropdowns,
        fields,
        filterFn,
      },
      stubs: { GlTab },
      slots: { header: headerSlot },
    });
  };

  const findBadge = () => wrapper.findComponent(GlBadge);
  const findReport = () => wrapper.findComponent(VulnerabilityReport);

  afterEach(() => {
    wrapper.destroy();
  });

  it('shows the expected tab title', () => {
    const title = 'custom tab title';
    createWrapper({ title });

    expect(wrapper.text()).toContain(title);
  });

  it.each([true, false])('passes the expected props to the vulnerability report', (isActiveTab) => {
    const filterDropdowns = [];
    const fields = [];
    const filterFn = () => {};

    createWrapper({ fields, dropdowns: filterDropdowns, filterFn, isActiveTab });

    expect(findReport().props()).toMatchObject({
      fields,
      filterDropdowns,
      filterFn,
      showCounts: true,
      isVisible: isActiveTab,
    });
  });

  it('shows the correct sum when the vulnerability report updates the counts', async () => {
    createWrapper();
    findReport().vm.$emit('counts-changed', [{ count: 8 }, { count: 3 }, { count: 5 }]);
    await nextTick();

    expect(findBadge().text()).toBe('16');
  });

  it('shows the header slot content', () => {
    const headerSlot = 'header slot content';
    createWrapper({ headerSlot });

    expect(wrapper.text()).toContain(headerSlot);
  });
});
