import { shallowMountExtended } from 'helpers/vue_test_utils_helper';
import DetailsSectionListItem from 'ee/security_dashboard/components/shared/vulnerability_details_graphql/details_section_list_item.vue';

describe('ee/security_dashboard/components/shared/vulnerability_details_graphql/details_section_list_item.vue', () => {
  let wrapper;

  const defaultRequiredProps = {
    label: 'Description:',
  };

  const createComponent = (options = {}) => {
    wrapper = shallowMountExtended(DetailsSectionListItem, {
      propsData: {
        ...defaultRequiredProps,
      },
      ...options,
    });
  };

  afterEach(() => {
    wrapper.destroy();
  });

  it('renders the label within a `strong` tag', () => {
    createComponent({});

    expect(wrapper.find('strong').text()).toContain(defaultRequiredProps.label);
  });

  it('renders content that gets passed to the default slot', () => {
    const defaultSlotContent = 'Critical Severity';
    createComponent({
      slots: {
        default: defaultSlotContent,
      },
    });

    expect(wrapper.html()).toContain(defaultSlotContent);
  });
});
