import { mount } from '@vue/test-utils';
import VulnerabilityIssueLink from 'ee/security_dashboard/components/pipeline/vulnerability_issue_link.vue';

describe('Vulnerability Issue Link component', () => {
  let wrapper;

  const createComponent = () => {
    const issue = {
      issue_iid: 1,
      issue_url: 'https://gitlab.com',
    };
    const projectName = 'Project Name';
    const propsData = { issue, projectName };
    wrapper = mount(VulnerabilityIssueLink, { propsData });
  };

  beforeEach(() => {
    createComponent();
  });

  afterEach(() => {
    wrapper.destroy();
  });

  it('should render the severity label', () => {
    const props = wrapper.props();

    expect(wrapper.text()).toContain(`${props.projectName}#${props.issue.issue_iid}`);
  });

  it('should link to the issue', () => {
    const link = wrapper.find('a');

    expect(link.attributes('href')).toMatch(wrapper.props().issue.issue_url);
  });
});
