import { GlLink } from '@gitlab/ui';
import { shallowMount } from '@vue/test-utils';
import DependencyVulnerability from 'ee/dependencies/components/dependency_vulnerability.vue';
import SeverityBadge from 'ee/vue_shared/security_reports/components/severity_badge.vue';
import { extendedWrapper } from 'helpers/vue_test_utils_helper';
import mockDataVulnerabilities from 'ee_jest/security_dashboard/store/modules/vulnerabilities/data/mock_data_vulnerabilities';

describe('DependencyVulnerability component', () => {
  let wrapper;
  const findLink = () => wrapper.findComponent(GlLink);

  const factory = ({ propsData, ...options } = {}, standaloneVulnDependencyList = false) => {
    wrapper = extendedWrapper(
      shallowMount(DependencyVulnerability, {
        ...options,
        propsData: { ...propsData },
        provide: {
          glFeatures: {
            standaloneVulnDependencyList,
          },
        },
      }),
    );
  };

  afterEach(() => {
    wrapper.destroy();
  });

  describe('given an vulnerability', () => {
    const vulnerability = mockDataVulnerabilities[0];
    beforeEach(() => {
      factory({
        propsData: {
          vulnerability,
        },
      });
    });

    it('matches the snapshot', () => {
      expect(wrapper.element).toMatchSnapshot();
    });

    it('renders the severity badge with the correct props', () => {
      const badge = wrapper.findComponent(SeverityBadge);
      expect(badge.isVisible()).toBe(true);
      expect(badge.props().severity).toEqual(vulnerability.severity);
    });

    it('renders the vulnerability name as a Link', () => {
      const link = findLink();
      expect(link.exists()).toBe(true);
      expect(link.element.getAttribute('href')).toBe(
        '/testgroup/testproject/-/security/vulnerabilities/1',
      );
    });
  });
});
