# frozen_string_literal: true

module Gitlab
  module Vulnerabilities
    class ContainerScanningVulnerability < BaseVulnerability
      def title
        format_data(
          :name =>
            '%{name}',
          %i[vulnerability featurename] =>
            '%{vulnerability} in %{featurename}',
          :vulnerability =>
            '%{vulnerability}'
        )
      end

      def description
        format_data(
          :description =>
            '%{description}',
          %i[featurename featureversion] =>
            '**%{featurename}** `%{featureversion}` is affected by %{vulnerability}',
          :featurename =>
            '**%{featurename}** is affected by %{vulnerability}',
          :namespace =>
            '**%{namespace}** is affected by %{vulnerability}'
        )
      end

      def solution
        format_data(
          :solution =>
            '%{solution}',
          %i[fixedby featurename featureversion] =>
            'Upgrade **%{featurename}** from `%{featureversion}` to `%{fixedby}`',
          %i[fixedby featurename] =>
            'Upgrade **%{featurename}** to `%{fixedby}`',
          :fixedby => 'Upgrade to `%{fixedby}`'
        )
      end

      private

      def format_data(definitions)
        format = definitions.find do |keys, _|
          data.values_at(*Array.wrap(keys)).all?(&:present?)
        end

        sprintf(format.last, data) if format
      end
    end
  end
end
