# frozen_string_literal: true

module VulnerabilityExports
  class ExportWorker
    include ApplicationWorker

    data_consistency :always

    sidekiq_options retry: 3
    include ::Gitlab::ExclusiveLeaseHelpers

    sidekiq_options dead: false

    feature_category :vulnerability_management
    worker_resource_boundary :cpu

    idempotent!

    sidekiq_retries_exhausted do |job|
      Vulnerabilities::Export.find_by_id(job['args'].last).failed!
    end

    def perform(vulnerability_export_id)
      vulnerability_export = Vulnerabilities::Export.find_by_id(vulnerability_export_id)
      return unless vulnerability_export

      ExportService.export(vulnerability_export)
    end
  end
end
