# frozen_string_literal: true

module VulnerabilityExports
  module Exporters
    class CsvService
      IDENTIFIER_DELIMITER = '; '
      IDENTIFIER_FORMATTER = -> (v) { v&.other_identifier_values&.to_csv(col_sep: IDENTIFIER_DELIMITER, row_sep: '') }
      MAPPING = {
        'Group Name' => 'group_name',
        'Project Name' => 'project_name',
        'Tool' => 'report_type',
        'Scanner Name' => 'finding_scanner_name',
        'Status' => 'state',
        'Vulnerability' => 'title',
        'Details' => 'finding_description',
        'Additional Info' => 'finding_message',
        'Severity' => 'severity',
        'CVE' => 'cve_value',
        'CWE' => 'cwe_value',
        'Other Identifiers' => IDENTIFIER_FORMATTER,
        'Detected At' => 'created_at',
        'Location' => 'location',
        'Activity' => 'resolved_on_default_branch',
        'Comments' => 'notes_summary'
      }.freeze

      attr_reader :vulnerabilities

      def initialize(vulnerabilities)
        @vulnerabilities = vulnerabilities
      end

      def generate(&block)
        csv_builder.render(&block)
      end

      private

      def csv_builder
        @csv_builder ||= CsvBuilder.new(vulnerabilities, MAPPING)
      end
    end
  end
end

VulnerabilityExports::Exporters::CsvService.prepend_mod
