# frozen_string_literal: true
module Types
  class VulnerabilityScannerInputType < BaseInputObject
    argument :id, GraphQL::Types::String,
          description: 'Unique ID that identifies the scanner.',
          required: true

    argument :name, GraphQL::Types::String,
          description: 'Human readable value that identifies the analyzer, not required to be unique.',
          required: true

    argument :url, GraphQL::Types::String,
          description: 'Link to more information about the analyzer.',
          required: true

    argument :vendor, Types::VulnerabilityScannerVendorInputType,
          description: 'Information about vendor/maintainer of the scanner.',
          required: false

    argument :version, GraphQL::Types::String,
          description: 'Version of the scanner.',
          required: true
  end
end
