# frozen_string_literal: true

module Types
  module VulnerabilityDetails
    # rubocop: disable Graphql/AuthorizeTypes
    class BooleanType < BaseType
      graphql_name 'VulnerabilityDetailBoolean'
      description 'Represents the vulnerability details boolean value'

      field :value, GraphQL::Types::Boolean, null: false, description: 'Value of the field.'
    end
  end
end
