# frozen_string_literal: true

module Types
  module VulnerabilityDetails
    # rubocop: disable Graphql/AuthorizeTypes
    class BaseType < BaseObject
      graphql_name 'VulnerabilityDetailBase'
      description 'Represents the vulnerability details base'

      field :field_name, GraphQL::Types::String,
        null: true, description: 'Name of the field.'

      field :name, GraphQL::Types::String,
        null: true, description: 'Name of the field.'

      field :description, GraphQL::Types::String,
        null: true, description: 'Description of the field.'
    end
  end
end
