---
stage: Systems
group: Distribution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Support for Alpha, Beta, Limited Availability, and Generally Available features **(PREMIUM)**

Some GitLab features are released as Alpha or Beta versions and are
[not fully supported](https://about.gitlab.com/support/statement-of-support/#alpha-beta-features).
All other features are considered to be Generally Available (GA).

## Alpha features

Support is **not** provided for Alpha features and issues with them should be opened in the [GitLab issue tracker](https://gitlab.com/gitlab-org/gitlab/issues).

Characteristics of Alpha features:

- Not ready for production use.
- Unstable and can cause performance and stability issues.
- Configuration and dependencies are likely to change.
- Features and functions may be removed. Breaking changes may occur outside of major releases or with less notice than for Beta or Generally Available features.
- Data loss can occur (be that through bugs or updates).
- Documentation reflects the Alpha status.
- Behind flags that are off by default.
- Not announced in release posts.

## Beta features

Your Support Contract provides **commercially-reasonable effort** support for Beta features, with the expectation that issues require extra time and assistance from development to troubleshoot.

### Closed Beta features

Closed Beta features are available to selected users only.

- Not ready for production use.
- Unstable and can cause performance and stability issues.
- Configuration and dependencies unlikely to change.
- Features and functions unlikely to change. However, breaking changes may occur outside of major releases or with less notice than for Generally Available features.
- Data loss less likely.
- Behind a feature flag that is off by default and the UI reflects Beta status.
- Documentation reflects Beta status.
- Can be announced in a release post that reflects Beta status.

### Open Beta features

- Not ready for production use.
- Unstable and can cause performance and stability issues.
- Configuration and dependencies unlikely to change.
- Features and functions unlikely to change. However, breaking changes may occur outside of major releases or with less notice than for Generally Available features.
- Data loss not likely.
- Support on a commercially-reasonable effort basis.
- Documentation reflects Beta status.
- Behind a feature flag that is on by default and the UI reflects Beta status.
- Behind a toggle that is off by default and the UI reflects Beta status.
- Can be announced in a release post that reflects Beta status.

## Limited Availability (LA)

Characteristics of Limited Availability features:

- Ready for production use by a small set of customers.
- Can be booked by Deal Desk as part of an order.
- Fully documented and [supported](https://about.gitlab.com/support/statement-of-support/#starter-premium-and-ultimate-users).

## Generally Available (GA)

Generally Available features means that they passed the [Production Readiness Review](https://gitlab.com/gitlab-com/gl-infra/readiness/-/blob/master/.gitlab/issue_templates/production_readiness.md) for GitLab.com, and are:

- Ready for production use at any scale.
- Fully documented and supported.
