---
stage: Verify
group: Pipeline Execution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# GitLab CI/CD artifacts reports types **(FREE)**

Use [`artifacts:reports`](index.md#artifactsreports) to:

- Collect test reports, code quality reports, security reports, and other artifacts generated by included templates in
  jobs.
- Some of these reports are used to display information in:
  - Merge requests.
  - Pipeline views.
  - [Security dashboards](../../user/application_security/security_dashboard/index.md).

Artifacts created for `artifacts: reports` are always uploaded, regardless of the job results (success or failure).
You can use [`artifacts:expire_in`](index.md#artifactsexpire_in) to set an expiration
date for the artifacts.

Some `artifacts:reports` types can be generated by multiple jobs in the same pipeline, and used by merge request or
pipeline features from each job.

To browse the report output files, ensure you include the [`artifacts:paths`](index.md#artifactspaths) keyword in your job definition.

NOTE:
Combined reports in parent pipelines using [artifacts from child pipelines](index.md#needspipelinejob) is
not supported. Track progress on adding support in [this issue](https://gitlab.com/gitlab-org/gitlab/-/issues/215725).

## `artifacts:reports:accessibility`

> [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/39425) in GitLab 12.8.

The `accessibility` report uses [pa11y](https://pa11y.org/) to report on the accessibility impact
of changes introduced in merge requests.

GitLab can display the results of one or more reports in the merge request
[accessibility widget](../testing/accessibility_testing.md#accessibility-merge-request-widget).

For more information, see [Accessibility testing](../testing/accessibility_testing.md).

## `artifacts:reports:api_fuzzing` **(ULTIMATE)**

> - Introduced in GitLab 13.4.
> - Requires GitLab Runner 13.4 or later.

The `api_fuzzing` report collects [API Fuzzing bugs](../../user/application_security/api_fuzzing/index.md)
as artifacts.

GitLab can display the results of one or more reports in:

- The merge request [security widget](../../user/application_security/api_fuzzing/index.md#view-details-of-an-api-fuzzing-vulnerability).
- The [Project Vulnerability report](../../user/application_security/vulnerability_report/index.md).
- The pipeline [**Security** tab](../../user/application_security/vulnerability_report/pipeline.md#view-vulnerabilities-in-a-pipeline).
- The [security dashboard](../../user/application_security/api_fuzzing/index.md#security-dashboard).

## `artifacts:reports:browser_performance` **(PREMIUM)**

> [Name changed](https://gitlab.com/gitlab-org/gitlab/-/issues/225914) from `artifacts:reports:performance` in GitLab 14.0.

The `browser_performance` report collects [Browser Performance Testing metrics](../testing/browser_performance_testing.md)
as artifacts.

GitLab can display the results of one report in the merge request
[browser performance testing widget](../testing/browser_performance_testing.md#how-browser-performance-testing-works).

GitLab cannot display the combined results of multiple `browser_performance` reports.

## `artifacts:reports:coverage_report`

> [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/344533) in GitLab 14.10.

Use `coverage_report` to collect coverage report in Cobertura format.

The `cobertura` report collects [Cobertura coverage XML files](../testing/test_coverage_visualization.md).

Cobertura was originally developed for Java, but there are many third-party ports for other languages such as
JavaScript, Python, and Ruby.

```yaml
artifacts:
  reports:
    coverage_report:
      coverage_format: cobertura
      path: coverage/cobertura-coverage.xml
```

The collected coverage report is uploaded to GitLab as an artifact. You can use
only one report per job.

GitLab can display the results of coverage report in the merge request
[diff annotations](../testing/test_coverage_visualization.md).

## `artifacts:reports:codequality`

> - [Moved](https://gitlab.com/gitlab-org/gitlab/-/issues/212499) to GitLab Free in 13.2.
> - [Added support for multiple reports in diff annotations and full pipeline report](https://gitlab.com/gitlab-org/gitlab/-/issues/9014) in 15.7.

The `codequality` report collects [code quality issues](../testing/code_quality.md). The
collected code quality report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in:

- The merge request [code quality widget](../testing/code_quality.md#merge-request-widget).
- The merge request [diff annotations](../testing/code_quality.md#merge-request-changes-view).
- The [full report](../testing/metrics_reports.md).

## `artifacts:reports:container_scanning` **(ULTIMATE)**

The `container_scanning` report collects [Container Scanning vulnerabilities](../../user/application_security/container_scanning/index.md).
The collected Container Scanning report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in:

- The merge request [container scanning widget](../../user/application_security/container_scanning/index.md).
- The pipeline [**Security** tab](../../user/application_security/vulnerability_report/pipeline.md#view-vulnerabilities-in-a-pipeline).
- The [security dashboard](../../user/application_security/security_dashboard/index.md).
- The [Project Vulnerability report](../../user/application_security/vulnerability_report/index.md).

## `artifacts:reports:coverage_fuzzing` **(ULTIMATE)**

> - Introduced in GitLab 13.4.
> - Requires GitLab Runner 13.4 or later.

The `coverage_fuzzing` report collects [coverage fuzzing bugs](../../user/application_security/coverage_fuzzing/index.md).
The collected coverage fuzzing report uploads to GitLab as an artifact.
GitLab can display the results of one or more reports in:

- The merge request [coverage fuzzing widget](../../user/application_security/coverage_fuzzing/index.md#interacting-with-the-vulnerabilities).
- The pipeline [**Security** tab](../../user/application_security/vulnerability_report/pipeline.md#view-vulnerabilities-in-a-pipeline).
- The [Project Vulnerability report](../../user/application_security/vulnerability_report/index.md).
- The [security dashboard](../../user/application_security/security_dashboard/index.md).

## `artifacts:reports:cyclonedx`

> [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/360766) in GitLab 15.3

This report is a Software Bill of Materials describing the components of a project
following the [CycloneDX](https://cyclonedx.org/docs/1.4) protocol format.

You can specify multiple CycloneDX reports per job. These can be either supplied
as a list of filenames, a filename pattern, or both:

- List of filenames: `cyclonedx: [gl-sbom-npm-npm.cdx.json, gl-sbom-bundler-gem.cdx.json]`.
- A filename pattern: `cyclonedx: gl-sbom-*.json`.
- Combination of both of the above: `cyclonedx: [gl-sbom-*.json, my-cyclonedx.json]`.

Below is an example of a job exposing CycloneDX artifacts:

```yaml
artifacts:
  reports:
    cyclonedx:
      - gl-sbom-npm-npm.cdx.json
      - gl-sbom-bundler-gem.cdx.json
```

## `artifacts:reports:dast` **(ULTIMATE)**

The `dast` report collects [DAST vulnerabilities](../../user/application_security/dast/index.md). The collected DAST
report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in:

- The merge request security widget.
- The pipeline [**Security** tab](../../user/application_security/vulnerability_report/pipeline.md#view-vulnerabilities-in-a-pipeline).
- The [Project Vulnerability report](../../user/application_security/vulnerability_report/index.md).
- The [security dashboard](../../user/application_security/security_dashboard/index.md).

## `artifacts:reports:dependency_scanning` **(ULTIMATE)**

The `dependency_scanning` report collects [Dependency Scanning vulnerabilities](../../user/application_security/dependency_scanning/index.md).
The collected Dependency Scanning report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in:

- The merge request [dependency scanning widget](../../user/application_security/dependency_scanning/index.md).
- The pipeline [**Security** tab](../../user/application_security/vulnerability_report/pipeline.md#view-vulnerabilities-in-a-pipeline).
- The [security dashboard](../../user/application_security/security_dashboard/index.md).
- The [Project Vulnerability report](../../user/application_security/vulnerability_report/index.md).
- The [dependency list](../../user/application_security/dependency_list/index.md).

## `artifacts:reports:dotenv`

> [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/17066) in GitLab 12.9.

The `dotenv` report collects a set of environment variables as artifacts.

The collected variables are registered as runtime-created variables of the job,
which you can use to [set dynamic environment URLs after a job finishes](../environments/index.md#set-dynamic-environment-urls-after-a-job-finishes).

If duplicate environment variables are present in a `dotenv` report:

- In GitLab 14.6 and later, the last one specified is used.
- In GitLab 14.5 and earlier, an error occurs.

The exceptions to the [original dotenv rules](https://github.com/motdotla/dotenv#rules) are:

- The variable key can contain only letters, digits, and underscores (`_`).
- The maximum size of the `.env` file is 5 KB.
  This limit [can be changed on self-managed instances](../../administration/instance_limits.md#limit-dotenv-file-size).
- On GitLab.com, [the maximum number of inherited variables](../../user/gitlab_com/index.md#gitlab-cicd)
  is 50 for Free, 100 for Premium and 150 for Ultimate. The default for
  self-managed instances is 150, and can be changed by changing the
  `dotenv_variables` [application limit](../../administration/instance_limits.md#limit-dotenv-variables).
- Variable substitution in the `.env` file is not supported.
- [Multiline values in the `.env` file](https://github.com/motdotla/dotenv#multiline-values) are not supported.
- The `.env` file can't have empty lines or comments (starting with `#`).
- Key values in the `env` file cannot have spaces or newline characters (`\n`), including when using single or double quotes.
- Quote escaping during parsing (`key = 'value'` -> `{key: "value"}`) is not supported.
- Only UTF-8 encoding is [supported](../pipelines/job_artifacts.md#error-message-fatal-invalid-argument-when-uploading-a-dotenv-artifact-on-a-windows-runner).

## `artifacts:reports:junit`

The `junit` report collects [JUnit report format XML files](https://www.ibm.com/docs/en/adfz/developer-for-zos/14.1.0?topic=formats-junit-xml-format).
The collected Unit test reports upload to GitLab as an artifact. Although JUnit was originally developed in Java, there
are many third-party ports for other languages such as JavaScript, Python, and Ruby.

See [Unit test reports](../testing/unit_test_reports.md) for more details and examples.
Below is an example of collecting a JUnit report format XML file from Ruby's RSpec test tool:

```yaml
rspec:
  stage: test
  script:
    - bundle install
    - rspec --format RspecJunitFormatter --out rspec.xml
  artifacts:
    reports:
      junit: rspec.xml
```

GitLab can display the results of one or more reports in:

- The merge request [code quality widget](../testing/unit_test_reports.md#how-it-works).
- The [full report](../testing/unit_test_reports.md#view-unit-test-reports-on-gitlab).

Some JUnit tools export to multiple XML files. You can specify multiple test report paths in a single job to
concatenate them into a single file. Use either:

- A filename pattern (`junit: rspec-*.xml`).
- an array of filenames (`junit: [rspec-1.xml, rspec-2.xml, rspec-3.xml]`).
- A Combination of both (`junit: [rspec.xml, test-results/TEST-*.xml]`).

## `artifacts:reports:license_scanning` **(ULTIMATE)**

> Introduced in GitLab 12.8.

The License Compliance report collects [Licenses](../../user/compliance/license_compliance/index.md). The License
Compliance report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in:

- The merge request [license compliance widget](../../user/compliance/license_compliance/index.md).
- The [license list](../../user/compliance/license_list.md).

## `artifacts:reports:load_performance` **(PREMIUM)**

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/35260) in GitLab 13.2.
> - Requires GitLab Runner 11.5 and above.

The `load_performance` report collects [Load Performance Testing metrics](../testing/load_performance_testing.md).
The report is uploaded to GitLab as an artifact.

GitLab can display the results of only one report in the merge request
[load testing widget](../testing/load_performance_testing.md#how-load-performance-testing-works).

GitLab cannot display the combined results of multiple `load_performance` reports.

## `artifacts:reports:metrics` **(PREMIUM)**

The `metrics` report collects [Metrics](../testing/metrics_reports.md). The collected Metrics report uploads to GitLab as an
artifact.

GitLab can display the results of one or more reports in the merge request
[metrics reports widget](../testing/metrics_reports.md#metrics-reports).

## `artifacts:reports:requirements` **(ULTIMATE)**

> [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/2859) in GitLab 13.1.

The `requirements` report collects `requirements.json` files. The collected Requirements report uploads to GitLab as an
artifact and existing [requirements](../../user/project/requirements/index.md) are marked as Satisfied.

GitLab can display the results of one or more reports in the
[project requirements](../../user/project/requirements/index.md#view-a-requirement).

## `artifacts:reports:sast`

> [Moved](https://gitlab.com/groups/gitlab-org/-/epics/2098) from GitLab Ultimate to GitLab Free in 13.3.

The `sast` report collects [SAST vulnerabilities](../../user/application_security/sast/index.md). The collected SAST
report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in:

- The merge request [SAST widget](../../user/application_security/sast/index.md#static-application-security-testing-sast).
- The [security dashboard](../../user/application_security/security_dashboard/index.md).

## `artifacts:reports:secret_detection`

> - Introduced in GitLab 13.1.
> - [Moved](https://gitlab.com/gitlab-org/gitlab/-/issues/222788) to GitLab Free in 13.3.
> - Requires GitLab Runner 11.5 and above.

The `secret-detection` report collects [detected secrets](../../user/application_security/secret_detection/index.md).
The collected Secret Detection report is uploaded to GitLab.

GitLab can display the results of one or more reports in:

- The merge request [secret scanning widget](../../user/application_security/secret_detection/index.md).
- The [pipeline **Security** tab](../../user/application_security/index.md#view-security-scan-information-in-the-pipeline-security-tab).
- The [security dashboard](../../user/application_security/security_dashboard/index.md).

## `artifacts:reports:terraform`

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/207528) in GitLab 13.0.
> - Requires [GitLab Runner](https://docs.gitlab.com/runner/) 11.5 and above.

The `terraform` report obtains a Terraform `tfplan.json` file. [JQ processing required to remove credentials](../../user/infrastructure/iac/mr_integration.md#configure-terraform-report-artifacts).
The collected Terraform plan report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in the merge request
[terraform widget](../../user/infrastructure/iac/mr_integration.md#output-terraform-plan-information-into-a-merge-request).

For more information, see [Output `terraform plan` information into a merge request](../../user/infrastructure/iac/mr_integration.md).
