# frozen_string_literal: true

class AddIndexToVulnerabilityReads < Gitlab::Database::Migration[1.0]
  INDEX_NAME = 'index_vulnerability_reads_common_finder_query'

  disable_ddl_transaction!

  def up
    add_concurrent_index(
      :vulnerability_reads,
      %i[project_id state report_type severity vulnerability_id],
      name: INDEX_NAME,
      order: { vulnerability_id: :desc }
    )
  end

  def down
    remove_concurrent_index_by_name(
      :vulnerability_reads,
      INDEX_NAME
    )
  end
end
