# frozen_string_literal: true

class CreateVulnerabilityStateTransition < Gitlab::Database::Migration[2.0]
  enable_lock_retries!

  def up
    create_table :vulnerability_state_transitions do |t|
      t.references :vulnerability, index: true, null: false, foreign_key: { on_delete: :cascade }
      t.integer :to_state, limit: 2, null: false
      t.integer :from_state, limit: 2, null: false
      t.timestamps_with_timezone null: false
    end
  end

  def down
    drop_table :vulnerability_state_transitions
  end
end
